/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.node;

import me.lucko.spark.common.sampler.node.AbstractNode;
import me.lucko.spark.common.sampler.node.MergeMode;
import me.lucko.spark.common.sampler.node.StackTraceNode;
import me.lucko.spark.common.sampler.window.ProtoTimeEncoder;
import me.lucko.spark.proto.SparkSamplerProtos;

public final class ThreadNode
extends AbstractNode {
    private final String name;
    public String label;

    public ThreadNode(String name) {
        this.name = name;
    }

    public String getThreadLabel() {
        return this.label != null ? this.label : this.name;
    }

    public String getThreadGroup() {
        return this.name;
    }

    public void setThreadLabel(String label) {
        this.label = label;
    }

    public <T> void log(StackTraceNode.Describer<T> describer, T[] stack, long time, int window) {
        if (stack.length == 0) {
            return;
        }
        this.getTimeAccumulator(window).add(time);
        AbstractNode node = this;
        Object previousElement = null;
        for (int offset = 0; offset < Math.min(300, stack.length); ++offset) {
            T element = stack[stack.length - 1 - offset];
            node = node.resolveChild(describer.describe(element, previousElement));
            node.getTimeAccumulator(window).add(time);
            previousElement = element;
        }
    }

    public SparkSamplerProtos.ThreadNode toProto(MergeMode mergeMode, ProtoTimeEncoder timeEncoder) {
        SparkSamplerProtos.ThreadNode.Builder proto = SparkSamplerProtos.ThreadNode.newBuilder().setName(this.getThreadLabel());
        double[] times = this.encodeTimesForProto(timeEncoder);
        for (double time : times) {
            proto.addTimes(time);
        }
        Object object = this.exportChildren(mergeMode).iterator();
        while (object.hasNext()) {
            StackTraceNode child = (StackTraceNode)object.next();
            proto.addChildren(child.toProto(mergeMode, timeEncoder));
        }
        return (SparkSamplerProtos.ThreadNode)proto.build();
    }
}

